from random import SystemRandom

from flask import (Flask, redirect, url_for,
    request, session, render_template)
from requests_oauthlib import OAuth2Session
import requests
from jose import jwt

random = SystemRandom()

CONFIG = {
    'client_id': "<CLIENT_ID>",
    'client_secret': "<CLIENT_SECRET>",
    'auth_url': 'https://auth.globus.org/v2/oauth2/authorize',
    'token_url': 'https://auth.globus.org/v2/oauth2/token',
    'redirect_uri': 'https://localhost/callback',
}

keys = requests.get('https://auth.globus.org/jwk.json').json()

OIDC_CONFIG = {
    'jwt_pubkeys': keys,
    'scope': ['openid', 'email', 'profile'],
    'expected_issuer': 'https://auth.globus.org',
    'algorithm': 'RS512'
}

CONFIG.update(OIDC_CONFIG)

app = Flask(__name__)
app.secret_key = "keep this secret"

@app.route('/login', methods=['GET'])
def login():
    provider = OAuth2Session(client_id=CONFIG['client_id'],
                             scope=CONFIG['scope'],
                             redirect_uri=CONFIG['redirect_uri'])
    nonce = str(random.randint(0, 1e10))

    url, state = provider.authorization_url(CONFIG['auth_url'],
                                            nonce=nonce)
    session['oauth2_state'] = state
    session['nonce'] = nonce
    return redirect(url)


@app.route('/callback', methods=['GET'])
def callback():
    provider = OAuth2Session(CONFIG['client_id'],
                             redirect_uri=CONFIG['redirect_uri'],
                             state=session['oauth2_state'])
    response = provider.fetch_token(
                         token_url=CONFIG['token_url'],
                         client_secret=CONFIG['client_secret'],
                         authorization_response=request.url)
    session['access_token'] = response['access_token']
    id_token = response['id_token']
    claims = jwt.decode(id_token,
                        key=CONFIG['jwt_pubkeys'],
                        issuer=CONFIG['expected_issuer'],
                        audience=CONFIG['client_id'],
                        algorithms=CONFIG['algorithm'],
                        access_token=response['access_token'])
    assert session['nonce'] == claims['nonce']
    session['user_id'] = claims['sub']
    session['user_email'] = claims['email']
    session['user_name'] = claims['name']
    return redirect(url_for('index'))

@app.route('/')
def index():
    if 'access_token' not in session:
        return redirect(url_for('login'))
    return render_template('index.html.jinja2',
                           user_name=session['user_name'])
