from flask import (Flask, redirect, url_for,
    request, session, render_template)
from requests_oauthlib import OAuth2Session
import requests

app = Flask(__name__)
app.secret_key = "keep this secret"

CONFIG = {
    'client_id': "<CLIENT_ID>",
    'client_secret': "<CLIENT_SECRET>",
    'auth_url': 'https://auth.globus.org/v2/oauth2/authorize',
    'token_url': 'https://auth.globus.org/v2/oauth2/token',
    'scope': ['urn:globus:auth:scope:transfer.api.globus.org:all'],
    'redirect_uri': 'https://localhost/callback',
}

@app.route('/login', methods=['GET'])
def login():
    provider = OAuth2Session(
                   client_id=CONFIG['client_id'],
                   scope=CONFIG['scope'],
                   redirect_uri=CONFIG['redirect_uri'])
    url, state = provider.authorization_url(CONFIG['auth_url'])
    session['oauth2_state'] = state
    return redirect(url)

@app.route('/callback', methods=['GET'])
def callback():
    provider = OAuth2Session(CONFIG['client_id'],
                             redirect_uri=CONFIG['redirect_uri'],
                             state=session['oauth2_state'])
    token_response = provider.fetch_token(
                        token_url=CONFIG['token_url'],
                        client_secret=CONFIG['client_secret'],
                        authorization_response=request.url)

    session['access_token'] = token_response['access_token']
    session['access_token_expires'] = token_response['expires_at']

    transfers = provider.get('https://transfer.api.globusonline.org/v0.10/task_list?limit=1')

    return redirect(url_for('index'))

@app.route('/')
def index():
    if 'access_token' not in session:
        return redirect(url_for('login'))
    transfers = requests.get('https://transfer.api.globusonline.org/v0.10/task_list?limit=1',
                             headers={'Authorization': 'Bearer ' + session['access_token']})
    return render_template('index.html.jinja2',
                           transfers=transfers.json())
